package com.swair.reservation;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

import java.util.Random;

/*
* La classe <code>AirAvailability</code> gre les donnes
* d'une disponibilit de la centrale de rservation arienne 
* SW-Air. 
*
* @version  1.0
*/
public class AirAvailability {
	
	private final static Random idGenerator = new Random();

	private int id = 0;

	private String airCompany = "";
	private String flightNumber = "";
	private String departureAirport = "";
	private String arrivalAirport = "";
	private String departureHour = "";
	private String arrivalHour = "";
	private boolean direction = true;
	private float price = 0;

	private int remoteId = 0;
	
	private Writer writer;

	/*
	* Le constructeur de disponibilit de la centrale de
	* rservation arienne.
	*/
	public AirAvailability() {
		getId();
		try {
			writer = new BufferedWriter(new OutputStreamWriter(System.out, "Cp850"));
		}
		catch(UnsupportedEncodingException e) {
			writer = new BufferedWriter(new OutputStreamWriter(System.out));
		}
	}

	/*
	* Renvoie l'identifiant de la disponibilit.
	*/
	public synchronized int getId() {
		if (id == 0) {
			id = idGenerator.nextInt();
		}
		setRemoteId(id);
		return id;
	}

	/*
	* Renvoie l'identifiant de la disponibilit
	* du partenaire.
	*/
	public int getRemoteId() {
		return this.remoteId;
	}

	/*
	* Affecte l'identifiant de la disponibilit
	* du partenaire.
	*
	* @param		remoteId l'identifiant de la 
	*				disponibilit du partenaire
	*/
	public void setRemoteId(int remoteId) {
		this.remoteId = remoteId;
	}

	/*
	* Affiche dans la log du serveur le statut de la
	* rservation effectue par l'utilisateur.
	*/
	public void status() {

		StringBuffer sb = new StringBuffer();
		sb.append("\n compagnie arienne : ");
		sb.append(getAirCompany());
		sb.append("\n n de vol : ");
		sb.append(getFlightNumber());
		sb.append("\n aroport dpart : ");
		sb.append(getDepartureAirport());
		sb.append("\n aroport arrive : ");
		sb.append(getArrivalAirport());
		sb.append("\n heure dpart : ");
		sb.append(getDepartureHour());
		sb.append("\n heure arrive : ");
		sb.append(getArrivalHour());
		sb.append("\n prix : ");
		sb.append(getPrice());
		sb.append("\n");
		try {
			writer.write(sb.toString());
			writer.flush();
		}
		catch(IOException e) {
			System.out.println(sb);
		}
	}

	/*
	* Renvoie le nom de la compagnie arienne.
	*/
	public String getAirCompany() {
		return airCompany;
	}

	/*
	* Affecte le nom de la compagnie arienne.
	*
	* @param		airCompany le nom de la compagnie 
	*				arienne
	*/
	public void setAirCompany(String airCompany) {
		this.airCompany = airCompany;
	}

	/*
	* Renvoie le n de vol.
	*/
	public String getFlightNumber() {
		return flightNumber;
	}

	/*
	* Affecte le n de vol.
	*
	* @param		flightNumber le n de vol
	*/
	public void setFlightNumber(String flightNumber) {
		this.flightNumber = flightNumber;
	}

	/*
	* Renvoie le nom de l'aroport de dpart.
	*/
	public String getDepartureAirport() {
		return departureAirport;
	}

	/*
	* Affecte le nom de l'aroport de dpart.
	*
	* @param		departureAirport le nom de l'aroport 
	*				de dpart
	*/
	public void setDepartureAirport(String departureAirport) {
		this.departureAirport = departureAirport;
	}

	/*
	* Renvoie le nom de l'aroport d'arrive.
	*/
	public String getArrivalAirport() {
		return arrivalAirport;
	}

	/*
	* Affecte le nom de l'aroport d'arrive.
	*
	* @param		arrivalAirport le nom de l'aroport 
	*				d'arrive
	*/
	public void setArrivalAirport(String arrivalAirport) {
		this.arrivalAirport = arrivalAirport;
	}

	/*
	* Renvoie l'heure de dpart.
	*/
	public String getDepartureHour() {
		return departureHour;
	}

	/*
	* Affecte l'heure de dpart.
	*
	* @param		departureHour l'heure de dpart
	*/
	public void setDepartureHour(String departureHour) {
		this.departureHour = departureHour;
	}

	/*
	* Renvoie l'heure d'arrive.
	*/
	public String getArrivalHour() {
		return arrivalHour;
	}

	/*
	* Affecte l'heure d'arrive.
	*
	* @param		arrivalHour l'heure d'arrive
	*/
	public void setArrivalHour(String arrivalHour) {
		this.arrivalHour = arrivalHour;
	}

	/*
	* Renvoie le sens du voyage.
	*/
	public boolean getDirection() {
		return direction;
	}

	/*
	* Affecte le sens du voyage.
	*
	* @param		direction le sens du voyage :
	*				true = aller et false = retour
	*/
	public void setDirection(boolean direction) {
		this.direction = direction;
	}

	/*
	* Renvoie le prix de rservation.
	*/
	public float getPrice() {
		return price;
	}

	/*
	* Affecte le prix de rservation.
	*
	* @param		price le prix
	*/
	public void setPrice(float price) {
		this.price = price;
	}

	/*
	* Renvoie une reprsentation textuelle de la
	* disponibilit du partenaire. 
	*
	* @return		une reprsentation textuelle de la
	* 				disponibilit.
	*/
	public String toString() {
		StringBuffer sb = new StringBuffer();
		sb.append("\n");
		sb.append(getClass().getName());
		sb.append("@");
		sb.append(Integer.toHexString(hashCode()));
		return sb.toString();
	}
}